% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cushforsim.R
\name{cushforsim}
\alias{cushforsim}
\title{Simulation routine for CUSH models without covariates}
\usage{
cushforsim(m, ordinal, shelter)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{shelter}{Category corresponding to the shelter choice}
}
\value{
An object of the class "CUSH", with null output for $BIC since the routine is only for
 simulation purposes
}
\description{
Fit CUSH models without covariates to given ordinal data. It is useful for simulation 
experiments since it performs the same steps as \code{\link{CUSH}}, but with no printed output.
}
\examples{
data(relgoods)
m<-10
ordinal<-na.omit(relgoods[,45])
shelter<-1
simul<-cushforsim(m, ordinal, shelter)
simul$estimates
simul$loglik
simul$varmat
}
\seealso{
\code{\link{CUSH}}
}
\keyword{htest}

