% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{COIN_to_coin}
\alias{COIN_to_coin}
\title{Convert a COIN to a coin}
\usage{
COIN_to_coin(COIN, recover_dsets = FALSE, out2 = "coin")
}
\arguments{
\item{COIN}{A COIN class object, generated by COINr version <= 0.6.1, OR a list containing IndData, IndMeta and
AggMeta entries.}

\item{recover_dsets}{Logical: if \code{TRUE}, will recover data sets other than "Raw" which are found in the
\code{.$Data} list.}

\item{out2}{If \code{"coin"} (default) outputs a coin, else if \code{"list"}, outputs a list with
\code{iData} and \code{iMeta} entries. This may be useful if you want to make further edits before building the coin.}
}
\value{
A coin class object if \code{out2 = "coin"}, else a list of data frames if \code{out2 = "list"}.
}
\description{
Converts an older COIN class to the newer coin class. Note that there are some limitations to this. First,
the function arguments used to create the COIN will not be passed to the coin, since the function arguments
are different. This means that any data sets beyond "Raw" cannot be regenerated. The second limitation is
that anything from the \code{.$Analysis} folder will not be passed on.
}
\details{
This function works by building the \code{iData} and \code{iMeta} arguments to \code{new_coin()}, using information from
the COIN. It then uses these to build a coin if \code{out2 = "coin"} or else outputs both data frames in a list.

If \code{recover_dsets = TRUE}, any data sets found in \code{COIN$Data} (except "Raw") will also be put in \code{coin$Data},
in the correct format. These can be used to inspect the data but not to regenerate.

Note that if you want to exclude any indicators, you will have to set \code{out2 = "list"} and build the coin
in a separate step with \code{exclude} specified. Any exclusions/inclusions from the COIN are not passed on
automatically.
}
\examples{
# see vignette("other_functions")

}
