% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_plotframework.R
\name{plotframework}
\alias{plotframework}
\title{Interactive sunburst plot of index structure}
\usage{
plotframework(COIN)
}
\arguments{
\item{COIN}{COIN object, or list with first entry is the indicator metadata, second entry is the aggregation metadata}
}
\value{
Interactive sunburst plot built using \strong{plotly}. This can be edited further with \strong{plotly} commands.
}
\description{
Plots the structure of the index using a sunburst plot using \strong{plotly}. Output can be used as an interactive plot
in html documents, e.g. via R Markdown.
}
\details{
Note that this plot is sensitive to the \emph{order} of the elements. If you use \code{\link[=assemble]{assemble()}} and input
a COIN, this plot should work automatically. If you input a list, you should make sure that the indicator metadata
is ordered by descending order of the hierarchy (i.e. highest level, working downwards).
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# plot framework
plotframework(ASEM)

}
