% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_sensitivity.R
\name{plotSA}
\alias{plotSA}
\title{Plot sensitivity indices}
\usage{
plotSA(SAresults, ptype = "bar")
}
\arguments{
\item{SAresults}{A list of sensitivity/uncertainty analysis results from \code{\link[=sensitivity]{sensitivity()}}.}

\item{ptype}{Type of plot to generate - either \code{"bar"}, \code{"pie"} or \code{"box"}.}
}
\value{
A plot of sensitivity indices generated by ggplot2.
}
\description{
Plots sensitivity indices as bar or pie charts.
}
\details{
To use this function you first need to run \code{\link[=sensitivity]{sensitivity()}}. Then enter the resulting list as the
\code{SAresults} argument here.
See \href{https://bluefoxr.github.io/COINrDoc/sensitivity-analysis.html}{COINr online documentation} for more details.
}
\examples{
\donttest{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()

# define noise to be applied to weights
nspecs <- data.frame(AgLevel = c(2,3), NoiseFactor = c(0.25,0.25))

# create list specifying assumptions to vary and alternatives
SAspecs <- list(
  normalise = list(ntype = c("minmax", "rank", "dist2max")),
  weights = list(NoiseSpecs = nspecs, Nominal = "Original")
)

# run uncertainty analysis
# here we set N deliberately much lower than normal to enable quick testing
# Would recommend in a practical case to increase to perhaps 500 (more is always better)
SAresults <- sensitivity(ASEM, v_targ = "Index",
                         SA_specs = SAspecs,
                         N = 5,
                         SA_type = "SA")

# Plot results as a bar chart
plotSA(SAresults, ptype = "bar")
}

}
\seealso{
\itemize{
\item \code{\link[=sensitivity]{sensitivity()}} Perform global sensitivity or uncertainty analysis on a COIN
\item \code{\link[=plotSARanks]{plotSARanks()}} Plot confidence intervals on ranks following a sensitivity analysis
}
}
