% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_datacheck.R
\name{checkData}
\alias{checkData}
\title{Detailed unit data check and screener by data availability}
\usage{
checkData(
  COIN,
  dset = NULL,
  ind_thresh = NULL,
  zero_thresh = NULL,
  unit_screen = "none",
  Force = NULL,
  out2 = "COIN"
)
}
\arguments{
\item{COIN}{The COIN object}

\item{dset}{The data set to be checked/screened}

\item{ind_thresh}{A data availability threshold used for flagging low data and screening units if \code{unit_screen != "none"}. Default 0.66. Specify as a fraction.}

\item{zero_thresh}{As ind_thresh but for non-zero values. Defaults to 0.05, i.e. it will flag any units with less than 5\% non-zero values (equivalently more than 95\% zero values).}

\item{unit_screen}{Specifies whether and how to screen units based on data availability or zero values.
\itemize{
\item If set to \code{"none"} (default), does not screen any units.
\item If set to \code{"byNA"}, screens units with data availability below \code{ind_thresh}
\item If set to \code{"byzeros"}, screens units with non-zero values below \code{zero_thresh}
\item If set to \code{"byNAandzeros"}, screens units based on either of the previous two criteria being true.
\item If you simply want to force a unit or units to be excluded (without any other screening), use the \code{Force} argument and set \code{unit_screen = TRUE}.
\code{unit_screen != "none"} outputs a new data set .$Data$Screened.
}}

\item{Force}{A data frame with any additional countries to force inclusion or exclusion. First column is \code{"UnitCode"}. Second column \code{"Status"} either \code{"Include"} or \code{"Exclude"} for each country to force.}

\item{out2}{Where to output the results. If \code{"COIN"} (default for COIN input), appends to updated COIN,
otherwise if \code{"list"} outputs to data frame.}
}
\value{
An updated COIN with data frames showing missing data in \code{.$Analysis}, and if \code{unit_screen != "none"} outputs a new data set .$Data$Screened.
If \code{out2 = "list"} wraps missing data stats and screened data set into a list.
}
\description{
Gives detailed tables of data availability, and optionally screens units based on a data
availability threshold and presence of zeros. Units can be optionally "forced" to be included or excluded, making
exceptions for the data availability threshold.
}
\details{
The two main criteria of interest are \code{NA} values, and zeros. The summary table gives percentages of
\code{NA} values for each unit, across indicators, and percentage zero values (\emph{as a percentage of non-\code{NA} values}).
Each unit is flagged as having low data or too many zeros based on thresholds.

This function currently only supports COINs as inputs, not data frames.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# return stats to the COIN, plus screened data set, return to list
ScreenedData <- checkData(ASEM, dset = "Raw", unit_screen = "byNA",
ind_thresh = 0.9, out2 = "list")
# See which units were removed
print(ScreenedData$RemovedUnits)

}
