% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_dom_relat.R
\name{cat_dom_relat}
\alias{cat_dom_relat}
\title{Categorize the dominant relationship from an ancestry match matrix}
\usage{
cat_dom_relat(AMM)
}
\arguments{
\item{AMM}{The ancestry match matrix to categorize}
}
\value{
This returns a list with two components:
\itemize{
\item \code{type}: a string saying what type of relationship (i.e., "Si", or "A").
\item \code{hits}: a two vector of the number of TRUEs in each "relationship zone" on the
upper or the lower diagonal of the AMM.
}
}
\description{
This function takes an ancestry match matrix (AMM) and it returns what the
"dominant" relationship is.  It doesn't try to capture all the nuances
that might be present in the AMM.  For example, it does not note inbreeding
and other such things.  However this is useful for categorizing what type
of relationship is the "closest" relationship type amongst all the ways a
pair is related.
Currently for num_generations == 2, the function goes through in this order,
to identify relationships:
\itemize{
\item \code{Se}: self.  This is as far as it goes with num_generations = 0
\item \code{PO}: parent-offspring
\item \code{Si}: sibling. This is as far as it goes with num_generations = 1
\item \code{GP}: grandparental
\item \code{A} : avuncular (aunt-niece)
\item \code{FC}: first cousin.
}
}
\details{
And so forth.  This has been implemented out to 3 generations
using the relationship zones in package data object
\code{relationship_zone_names}.
}
\examples{
cat_dom_relat(half_first_cousin_amm)
}
\keyword{internal}
