% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialClustering.R
\name{initialClustering}
\alias{initialClustering}
\title{Initial clustering}
\usage{
initialClustering(
  seu,
  batch.var = "Batch",
  cut.height = 0.4,
  nfeatures = 2000,
  additional.vars.to.regress = NULL,
  dims = seq_len(14),
  resolution = 0.6,
  downsampling.size = 50,
  verbose = FALSE
)
}
\arguments{
\item{seu}{Seurat S4 object. Required.}

\item{batch.var}{Character. One of the column names of `seu@meta.data`. It
is used to partition the Seurat object into smaller ones. Default: "Batch"}

\item{cut.height}{Numeric. Height used to cut hirerchical trees. Default:
0.4}

\item{nfeatures}{Number of high variance genes used. Default: 2000}

\item{additional.vars.to.regress}{Additional variables to regress out. Needs
to among column names of `seu@meta.data`. Default: `NULL`}

\item{dims}{Number of dimension used for clustering. Passed to Seurat.
Default: `1:14`}

\item{resolution}{Resolution for clustering. Passed to Seurat. Default: 0.6}

\item{downsampling.size}{Numeric. The number of cells representing each
group. (Default: 40)}

\item{verbose}{Print the progress bar or not. Default: FALSE}
}
\value{
Seurat S4 object with initial cluster information in
`initial_cluster` of meta.data.
}
\description{
Perform batch-specific initial clustering.
}
\seealso{
\code{\link{getIDEr}} \code{\link{finalClustering}}
}
