% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aovtype2.R
\name{aovtype2}
\alias{aovtype2}
\title{Anova Tables for Type 2 sums of squares}
\usage{
aovtype2(mod)
}
\arguments{
\item{mod}{aov model object from base R.}
}
\value{
An object of class "anova", which usually is printed.
}
\description{
Calculates and displays type-II analysis-of-variance tables for model objects 
produced by aov. This is a vastly reduced version of the Anova function from
package car
}
\details{
Details about how the function works in order of steps taken.
Type-II tests are invariant with respect to (full-rank) contrast coding.
Type-II tests are calculated according to the principle of marginality, 
testing each term after all others, except ignoring the term's higher-order
relatives.  This definition of Type-II tests corresponds to the tests 
produced by SAS for analysis-of-variance models, where all of the 
predictors are factors, but not more generally (i.e., when there are 
quantitative predictors).
}
\examples{

mtcars$cyl <- factor(mtcars$cyl)
mtcars$am <- factor(mtcars$am)
mod <- aov(hp ~ cyl * am, data = mtcars)
aovtype2(mod)
  
}
\references{
: Fox, J. (2016) Applied Regression Analysis and Generalized Linear Models, Third Edition. Sage.
}
\seealso{
\code{\link[stats]{aov}}
}
\author{
John Fox jfox@mcmaster.ca; as modified by Chuck Powell
}
