% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_neglogpost.R
\name{CGGP_internal_neglogpost}
\alias{CGGP_internal_neglogpost}
\title{Calculate negative log posterior}
\usage{
CGGP_internal_neglogpost(theta, CGGP, y, ..., ys = NULL, Xs = NULL,
  HandlingSuppData = "Correct")
}
\arguments{
\item{theta}{Correlation parameters}

\item{CGGP}{CGGP object}

\item{y}{Measured values of CGGP$design}

\item{...}{Forces you to name remaining arguments}

\item{ys}{Supplementary output data}

\item{Xs}{Supplementary input data}

\item{HandlingSuppData}{How should supplementary data be handled?
\itemize{
\item Correct: full likelihood with grid and supplemental data
\item Only: only use supplemental data
\item Ignore: ignore supplemental data
}}
}
\value{
Likelihood
}
\description{
Calculate negative log posterior
}
\examples{
cg <- CGGPcreate(d=3, batchsize=20)
Y <- apply(cg$design, 1, function(x){x[1]+x[2]^2})
cg <- CGGPfit(cg, Y)
CGGP_internal_neglogpost(cg$thetaMAP, CGGP=cg, y=cg$y)
}
