% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDrandom.R
\name{BDrandom}
\alias{BDrandom}
\alias{rbdbivgeo1}
\alias{rbdbivgeo2}
\title{Generates Random Deviates from the Basu-Dhar Bivariate Geometric Distribution}
\source{
\code{\link[BivGeo]{rbdbivgeo1}} generates random deviates using the inverse transformation method. Returns a matrix that the first column corresponds to X generated random values and the second column corresponds to Y generated random values.

\code{\link[BivGeo]{rbdbivgeo2}} generates random deviates using the shock model. Returns a matrix that the first column corresponds to X generated random values and the second column corresponds to Y generated random values. See Marshall and Olkin (1967) for more details.
}
\usage{
rbdbivgeo1(n, theta)
rbdbivgeo2(n, theta)
}
\arguments{
\item{n}{number of observations. If length(n) \eqn{> 1}, the length is taken to be the number required.}

\item{theta}{vector (of length 3) containing values of the parameters \eqn{\theta_1, \theta_2} and \eqn{\theta_{12}} of the Basu-Dhar bivariate Geometric distribution. The parameters are restricted to \eqn{0 < \theta_i < 1, i = 1,2} and \eqn{0 < \theta_{12} \le 1}.}
}
\value{
\code{\link[BivGeo]{rbdbivgeo1}} and \code{\link[BivGeo]{rbdbivgeo2}} generate random deviates from the Bash-Dhar bivariate geometric distribution. The length of the result is determined by n, and is the maximum of the lengths of the numerical arguments for the other functions.

Invalid arguments will return an error message.
}
\description{
This function generates random values from the Basu-Dhar bivariate geometric distribution assuming arbitrary parameter values.
}
\details{
The conditional distribution of X given Y is given by:

If X < Y, then
\deqn{P(X = x | Y = y) = \theta_1^{x - 1}(1 - \theta_1)}
If X = Y, then
\deqn{P(X = x | Y = y) = \frac{\theta_1^{x - 1}(1 - \theta_1 \theta_{12} - \theta_2 \theta_{12} + \theta_1 \theta_2 \theta_{12})}{1 - \theta_2 \theta_{12}} }
If X > Y, then
\deqn{P(X = x | Y = y) = \frac{\theta_1^{x - 1} \theta_{12}^{x - y}(1 - \theta_{1} \theta_{12}) (1 - \theta_2)}{1 - \theta_2 \theta_{12}}}
}
\examples{

rbdbivgeo1(10, c(0.5, 0.5, 0.7))
#       [,1] [,2]
#  [1,]    2    1
#  [2,]    3    1
#  [3,]    1    1
#  [4,]    1    1
#  [5,]    2    2
#  [6,]    1    3
#  [7,]    2    2
#  [8,]    1    1
#  [9,]    1    1
# [10,]    2    2

rbdbivgeo2(10, c(0.5, 0.5, 0.7))
#       [,1] [,2]
#  [1,]    1    1
#  [2,]    2    1
#  [3,]    2    1
#  [4,]    4    1
#  [5,]    1    1
#  [6,]    2    2
#  [7,]    3    2
#  [8,]    3    1
#  [9,]    3    2
# [10,]    1    1

}
\references{
Marshall, A. W., & Olkin, I. (1967). A multivariate exponential distribution. \emph{Journal of the American Statistical Association}, \bold{62}, 317, 30-44.

Basu, A. P., & Dhar, S. K. (1995). Bivariate geometric distribution. \emph{Journal of Applied Statistical Science}, \bold{2}, 1, 33-44.

Li, J., & Dhar, S. K. (2013). Modeling with bivariate geometric distributions. \emph{Communications in Statistics-Theory and Methods}, \bold{42}, 2, 252-266.

Achcar, J. A., Davarzani, N., & Souza, R. M. (2016). Basu–Dhar bivariate geometric distribution in the presence of covariates and censored data: a Bayesian approach. \emph{Journal of Applied Statistics}, \bold{43}, 9, 1636-1648.

de Oliveira, R. P., & Achcar, J. A. (2018). Basu-Dhar's bivariate geometric distribution in presence of censored data and covariates: some computational aspects. \emph{Electronic Journal of Applied Statistical Analysis}, \bold{11}, 1, 108-136.
}
\seealso{
\code{\link[stats]{Geometric}} for the univariate geometric distribution.
}
\author{
Ricardo P. Oliveira \email{rpuziol.oliveira@gmail.com}

Jorge Alberto Achcar \email{achcar@fmrp.usp.br}
}
