% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdIsLocked_hdf5}
\alias{bdIsLocked_hdf5}
\title{Test whether an HDF5 file is locked (in use)}
\usage{
bdIsLocked_hdf5(filename)
}
\arguments{
\item{filename}{Character. Path to the HDF5 file.}
}
\value{
Logical scalar: \code{TRUE} if locked/in use, \code{FALSE} otherwise.
}
\description{
Uses HDF5 file locking to check if \code{filename} can be opened in
read/write mode. If opening fails under locking, the file is treated
as "in use" and \code{TRUE} is returned. Non-existent files return
\code{FALSE}.
}
\details{
Requires HDF5 file locking (HDF5 >= 1.12 recommended). The
function sets \code{HDF5_USE_FILE_LOCKING=TRUE} for the process.
}
\examples{
\dontrun{
if (bdIsFileLocked("data.h5")) stop("File in use")
}
}
