% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TarNet.R
\name{TarNet}
\alias{TarNet}
\title{TarNet}
\usage{
TarNet(IIS, mm2path, r = 0.1, p_adjust = 0.05)
}
\arguments{
\item{IIS}{The result returned by IIS() function.}

\item{mm2path}{The results returned by MMfunc() function.}

\item{r}{A threshold value of correlation coefficient to construct the network. Default value is 0.1.}

\item{p_adjust}{A threshold value of correlation adjust p value to construct the network. Default  value is 0.05.}
}
\value{
TarnetPairs A data frame including target network pairs.
}
\description{
A function is used to plot a network that consists of microbes and metabolites in the shared pathway from the result of MMfunc() function.
}
\examples{
IIScore <- IIS(microApath = micro.eg, metaApath = metabo.eg,
               conf = confounder.eg, groupInfo = groupInfo.eg)
MMfunc_res <- MMfunc(IIS = IIScore)
TarNet_res <- TarNet(IIS = IIScore, mm2path = MMfunc_res)
}
