% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowfunction.R
\name{ClusterRowCoverage}
\alias{ClusterRowCoverage}
\title{Row Coverage Plots}
\usage{
ClusterRowCoverage(result, matrix, maxCluster = 20, noise = 0.1,
  noise_select = 0, plots = c(1:3), verbose = TRUE,
  plot.type = "device", filename = "RowCoverage")
}
\arguments{
\item{result}{A BiBitWorkflow Object.}

\item{matrix}{Accompanying binary data matrix which was used to obtain \code{result}.}

\item{maxCluster}{Maximum number of clusters to cut the tree at (default=20).}

\item{noise}{The allowed noise level when growing the rows on the merged patterns after cutting the tree. (default=\code{0.1}, namely allow 10\% noise.)
\itemize{
\item \code{noise=0}: No noise allowed.
\item \code{0<noise<1}: The \code{noise} parameter will be a noise percentage. The number of allowed 0's in a row in the bicluster will depend on the column size of the bicluster.
More specifically \code{zeros_allowed = ceiling(noise * columnsize)}. For example for \code{noise=0.10} and a bicluster column size of \code{5}, the number of allowed 0's would be \code{1}.
\item \code{noise>=1}: The \code{noise} parameter will be the number of allowed 0's in a row in the bicluster independent from the column size of the bicluster. In this noise option, the noise parameter should be an integer.
}}

\item{noise_select}{Should the allowed noise level be automatically selected for each pattern? (Using ad hoc method to find the elbow/kink in the Noise Scree plots)
\itemize{
\item \code{noise_select=0}: Do \emph{NOT} automatically select the noise levels. Use the the noise level given in the \code{noise} parameter (default)
\item \code{noise_select=1}: Using the Noise Scree plot (with 'Added Rows' on the y-axis), find the noise level where the current number of added rows at this noise level is larger than the mean of 'added rows' at the lower noise levels. 
After locating this noise level, lower the noise level by 1. This is your automatically selected elbow/kink and therefore your noise level.
\item \code{noise_select=2}: Applies the same steps as for \code{noise_select=1}, but instead of decreasing the noise level by only 1, keep decreasing the noise level until the number of added rows isn't decreasing anymore either.
}}

\item{plots}{Vector for which plots to draw:
\enumerate{
\item Number of Clusters versus Row Coverage Percentage
\item Number of Clusters versus Number of Row Coverage
\item Number of Clusters versus Final Number of Biclusters
}}

\item{verbose}{Logical value if the progress bar of merging/growing the biclusters should be shown. (default=\code{TRUE})}

\item{plot.type}{Output Type
\itemize{
\item \code{"device"}: All plots are outputted to new R graphics devices (default).
\item \code{"file"}: All plots are saved in external files. Plots are joint together in a single \code{.pdf} file.
\item \code{"other"}: All plots are outputted to the current graphics device, but will overwrite each other. Use this if you want to include one or more plots in a sweave/knitr file or if you want to export a single plot by your own chosen format.
}}

\item{filename}{Base filename (with/without directory) for the plots if \code{plot.type="file"} (default=\code{"RowCoverage"}).}
}
\value{
A data frame containing the number of clusters and the corresponding number of row coverage, percentage of row coverage and the number of final biclusters.
}
\description{
Plotting function to be used with the \code{\link{BiBitWorkflow}} output. It plots the number of clusters (of the hierarchical tree) versus the number/percentage of row coverage and number of final biclusters (see Details for more information).
}
\details{
The graph of number of chosen tree clusters versus the final row coverage can help you to make a decision on how many clusters to choose in the hierarchical tree. 
The more clusters you choose, the smaller (albeit more similar) the patterns are and the more rows will fit your patterns (i.e. more row coverage).
}
\examples{
\dontrun{
## Prepare some data ##
set.seed(254)
mat <- matrix(sample(c(0,1),5000*50,replace=TRUE,prob=c(1-0.15,0.15)),
              nrow=5000,ncol=50)
mat[1:200,1:10] <- matrix(sample(c(0,1),200*10,replace=TRUE,prob=c(1-0.9,0.9)),
                          nrow=200,ncol=10)
mat[300:399,6:15] <- matrix(sample(c(0,1),100*10,replace=TRUE,prob=c(1-0.9,0.9)),
                            nrow=100,ncol=10)
mat[400:599,21:30] <- matrix(sample(c(0,1),200*10,replace=TRUE,prob=c(1-0.9,0.9)),
                             nrow=200,ncol=10)
mat[700:799,29:38] <- matrix(sample(c(0,1),100*10,replace=TRUE,prob=c(1-0.9,0.9)),
                             nrow=100,ncol=10)
mat <- mat[sample(1:5000,5000,replace=FALSE),sample(1:50,50,replace=FALSE)]

## Apply BiBitWorkflow ##
out <- BiBitWorkflow(matrix=mat,minr=50,minc=5,noise=0.2,cut_type="number",cut_pm=10)
# Make ClusterRowCoverage Plots
ClusterRowCoverage(result=out,matrix=mat,maxCluster=20,noise=0.2)
}
}
\author{
Ewoud De Troyer
}

