% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_activations.R
\name{id_activations}
\alias{id_activations}
\title{Identify task activations}
\usage{
id_activations(
  model_obj,
  tasks = NULL,
  sessions = NULL,
  method = c("Bayesian", "classical"),
  alpha = 0.05,
  threshold = NULL,
  correction = c("FWER", "FDR", "none"),
  verbose = 1
)
}
\arguments{
\item{model_obj}{Result of \code{BayesGLM} or \code{BayesGLM_cifti} model
call, of class \code{"BayesGLM"} or \code{"BayesGLM_cifti"}.}

\item{tasks}{The task(s) to identify activations for. Give either the name(s)
as a character vector, or the numerical indices. If \code{NULL} (default),
analyze all tasks.}

\item{sessions}{The session(s) to identify activations for. Give either the
name(s) as a character vector, or the numerical indices. If \code{NULL}
(default), analyze the first session.

Currently, if multiple sessions are provided, activations are identified
separately for each session. (Information is not combined between the
different sessions.)}

\item{method}{\code{"Bayesian"} (default) or \code{"classical"}. If
\code{model_obj} does not have Bayesian results because \code{Bayes} was set
to \code{FALSE}, only the \code{"classical"} method can be used.}

\item{alpha}{Significance level. Default: \code{0.05}.}

\item{threshold}{Activation threshold, for example \code{1} for 1\\% signal
change if \code{scale_BOLD=="mean"} during model estimation. Setting a
\code{threshold} is required for the Bayesian method; \code{NULL} (default)
will use a \code{threshold} of zero for the classical method.}

\item{correction}{For the classical method only: Type of multiple comparisons
correction: \code{"FWER"} (Bonferroni correction, the default), \code{"FDR"}
(Benjamini Hochberg), or \code{"none"}.}

\item{verbose}{Should updates be printed? Use \code{1} (default) for
occasional updates, \code{2} for occasional updates as well as running INLA
in verbose mode (if applicable), or \code{0} for no updates.}
}
\value{
An \code{"act_BayesGLM"} or \code{"act_BayesGLM_cifti"} object, a
list which indicates the activated locations along with related information.
}
\description{
Identify areas of activation for each task from the result of \code{BayesGLM}
or \code{BayesGLM_cifti}.
}
