% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{determineNeighbors}
\alias{determineNeighbors}
\title{Determine the k-nearest neighbors for each spatial coordinate.}
\usage{
determineNeighbors(coords, k)
}
\arguments{
\item{coords}{N x 2 array of N 2-dimensional (x,y) spatial coordinates.}

\item{k}{Scalar; number of neighbors}
}
\value{
An N x k matrix of nearest neighbor indices
}
\description{
\code{determineNeighbors} returns an N x k matrix of the nearest neighbors 
for spatial locations coords, with the ith row giving indices of the k nearest 
neighbors to the ith location, which are selected from among the 1,...(i-1) 
other spatial locations. The first row is -1's, since the first location has 
no neighbors. The i=2 through i=(k+1) rows each necessarily contain 1:i.
}
\examples{
coords <- cbind(runif(100), runif(100))
determineNeighbors(coords, 20)

}
