% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dlm.R
\name{plot.DLM}
\alias{plot.DLM}
\title{DLM: Plot the life table}
\usage{
\method{plot}{DLM}(
  x,
  plotIC = TRUE,
  plotData = TRUE,
  labels = NULL,
  colors = NULL,
  linetype = NULL,
  prob = 0.95,
  age = NULL,
  ...
)
}
\arguments{
\item{x}{Object of the class \code{DLM} or \code{ClosedDLM} returned by the dlm() or dlm_close() functions.}

\item{plotIC}{Logical. If 'TRUE' (default), shows the predictive intervals.}

\item{plotData}{Logical. If 'TRUE' (default), shows crude rate (black dots).}

\item{labels}{Vector with the name of the curve label. (Optional).}

\item{colors}{Vector with the color of the curve. (Optional).}

\item{linetype}{Vector with the line type of the curve. (Optional).}

\item{prob}{Coverage probability of the predictive intervals. Default is '0.95'.}

\item{age}{Vector with the ages to plot the life table.}

\item{...}{Other arguments.}
}
\value{
A 'ggplot' object with fitted life table.
}
\description{
Function that returns a log-scale ggplot of the \code{DLM} and \code{ClosedDLM} objects returned by dlm() and dlm_close() functions.
}
\examples{
## Selecting the log mortality rate of the 1990 male population ranging from 0 to 100 years old
USA1990 = USA[USA$Year == 1990,]
x = 0:100
Ex = USA1990$Ex.Male[x+1]
Dx = USA1990$Dx.Male[x+1]
y = log(Dx/Ex)

## Fitting DLM
fit = dlm(y, ages = 0:100, M = 100)

## Plotting the life tables:
plot(fit)

## Now we are starting from 20 years
\donttest{
fit2 = dlm(y[21:101], Ft = 1, Gt = 1, ages = 20:100, M = 100)

plot(fit2, plotIC = FALSE)

## To plot multiples life tables see ?plot.list
plot(list(fit, fit2), age = 20:100,
     plotData = FALSE,
     colors = c("red", "blue"),
     labels = c("1", "2"))
}


}
\seealso{
\code{\link[=plot.HP]{plot.HP()}}, \code{\link[=plot.BLC]{plot.BLC()}} and \code{\link[=plot.PredBLC]{plot.PredBLC()}} for \code{HP}, \code{BLC} or \code{PredBLC} methods.

\code{\link[=plot.list]{plot.list()}} to the \code{list} method, adding multiple objects in one single plot.

\code{\link[=plot_chain]{plot_chain()}} to plot the chains generated by the MCMC algorithms for the \code{HP} and \code{DLM} objects.
}
