% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto-ggg-mcmc.R
\name{pggg.GenerateData}
\alias{pggg.GenerateData}
\title{Simulate data according to Pareto/GGG model assumptions}
\usage{
pggg.GenerateData(n, T.cal, T.star, params, date.zero = "2000-01-01")
}
\arguments{
\item{n}{Number of customers.}

\item{T.cal}{Length of calibration period. If a vector is provided, then it
is assumed that customers have different 'birth' dates, i.e.
\eqn{max(T.cal)-T.cal}.}

\item{T.star}{Length of holdout period. This may be a vector.}

\item{params}{A list of model parameters \code{r},
\code{alpha}, \code{s}, \code{beta}, \code{t} and \code{gamma}.}

\item{date.zero}{Initial date for cohort start. Can be of class character, Date or POSIXt.}
}
\value{
List of length 2:
\item{\code{cbs}}{A data.frame with a row for each customer and the summary statistic as columns.}
\item{\code{elog}}{A data.frame with a row for each transaction, and columns \code{cust}, \code{date} and \code{t}.}
}
\description{
Simulate data according to Pareto/GGG model assumptions
}
\examples{
params <- list(t = 4.5, gamma = 1.5, r = 5, alpha = 10, s = 0.8, beta = 12)
data <- pggg.GenerateData(n = 200, T.cal = 32, T.star = 32, params)
cbs <- data$cbs  # customer by sufficient summary statistic - one row per customer
elog <- data$elog  # Event log - one row per event/purchase
}
\references{
Platzer, M., & Reutterer, T. (2016). Ticking away the moments:
  Timing regularity helps to better predict customer activity. Marketing
  Science, 35(5), 779-799. \doi{10.1287/mksc.2015.0963}
}
