% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.PlotTrackingCum}
\alias{mcmc.PlotTrackingCum}
\title{Tracking Cumulative Transactions Plot for Pareto/GGG, Pareto/NBD (HB) and
Pareto/NBD (Abe)}
\usage{
mcmc.PlotTrackingCum(
  draws,
  T.cal,
  T.tot,
  actual.cu.tracking.data,
  xlab = "Week",
  ylab = "Cumulative Transactions",
  xticklab = NULL,
  title = "Tracking Cumulative Transactions",
  ymax = NULL,
  sample_size = 10000,
  covariates = NULL,
  legend = c("Actual", "Model")
)
}
\arguments{
\item{draws}{MCMC draws as returned by \code{*.mcmc.DrawParameters}}

\item{T.cal}{A vector to represent customers' calibration period lengths (in
other words, the \code{T.cal} column from a
customer-by-sufficient-statistic matrix). Considering rounding in order to
speed up calculations.}

\item{T.tot}{End of holdout period. Must be a single value, not a vector.}

\item{actual.cu.tracking.data}{A vector containing the cumulative number of
repeat transactions made by customers for each period in the total time
period (both calibration and holdout periods).}

\item{xlab}{Descriptive label for the x axis.}

\item{ylab}{Descriptive label for the y axis.}

\item{xticklab}{A vector containing a label for each tick mark on the x axis.}

\item{title}{Title placed on the top-center of the plot.}

\item{ymax}{Upper boundary for y axis.}

\item{sample_size}{Sample size for estimating the probability distribution.
See \code{\link{mcmc.ExpectedCumulativeTransactions}}.}

\item{covariates}{(optional) Matrix of covariates, for Pareto/NBD (Abe)
model, passed to \code{\link{abe.GenerateData}} for simulating data.}

\item{legend}{plot legend, defaults to `Actual` and `Model`.}
}
\value{
Matrix containing actual and expected cumulative repeat transactions.
}
\description{
Plots the actual and expected cumulative total repeat transactions by all
customers for the calibration and holdout periods, and returns this
comparison in a matrix.
}
\details{
The expected transactions need to be sampled. Due to this sampling, the
return result varies from one call to another. Larger values of
\code{sample_size} will generate more stable results.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-12-31")
cum <- elog2cum(groceryElog)
param.draws <- pnbd.mcmc.DrawParameters(cbs)
mat <- mcmc.PlotTrackingCum(param.draws,
  T.cal = cbs$T.cal,
  T.tot = max(cbs$T.cal + cbs$T.star),
  actual.cu.tracking.data = cum)
}
}
\seealso{
\code{\link{mcmc.PlotTrackingInc}}
  \code{\link{mcmc.ExpectedCumulativeTransactions}} \code{\link{elog2cum}}
}
