% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.PAlive}
\alias{mcmc.PAlive}
\title{Calculates P(alive) based on MCMC parameter draws}
\usage{
mcmc.PAlive(draws)
}
\arguments{
\item{draws}{MCMC draws as returned by \code{*.mcmc.DrawParameters}}
}
\value{
Numeric vector with the customers' probabilities of being still alive
  at end of calibration period
}
\description{
Calculates P(alive) based on MCMC parameter draws
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
param.draws <- pnbd.mcmc.DrawParameters(cbs,
  mcmc = 100, burnin = 50, thin = 10, chains = 1) # short MCMC to run demo fast
palive <- mcmc.PAlive(param.draws)
head(palive)
mean(palive)
}
