% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.PlotFrequencyInCalibration}
\alias{mbgcnbd.PlotFrequencyInCalibration}
\alias{bgcnbd.PlotFrequencyInCalibration}
\title{(M)BG/CNBD-k Plot Frequency in Calibration Period}
\usage{
mbgcnbd.PlotFrequencyInCalibration(
  params,
  cal.cbs,
  censor = 7,
  xlab = "Calibration period transactions",
  ylab = "Customers",
  title = "Frequency of Repeat Transactions"
)

bgcnbd.PlotFrequencyInCalibration(
  params,
  cal.cbs,
  censor = 7,
  xlab = "Calibration period transactions",
  ylab = "Customers",
  title = "Frequency of Repeat Transactions"
)
}
\arguments{
\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{cal.cbs}{Calibration period CBS (customer by sufficient statistic). It
must contain columns for frequency ('x') and total time observed ('T.cal').}

\item{censor}{Cutoff point for number of transactions in plot.}

\item{xlab}{Descriptive label for the x axis.}

\item{ylab}{Descriptive label for the y axis.}

\item{title}{Title placed on the top-center of the plot.}
}
\value{
Calibration period repeat transaction frequency comparison matrix
  (actual vs. expected).
}
\description{
Plots a histogram and returns a matrix comparing the actual and expected
number of customers who made a certain number of repeat transactions in the
calibration period, binned according to calibration period frequencies.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
params <- mbgcnbd.EstimateParameters(cbs)
mbgcnbd.PlotFrequencyInCalibration(params, cbs)
}
}
\references{
(M)BG/CNBD-k: Reutterer, T., Platzer, M., & Schroeder, N. (2020).
  Leveraging purchase regularity for predicting customer behavior the easy
  way. International Journal of Research in Marketing.
  \doi{10.1016/j.ijresmar.2020.09.002}
}
