% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGrid.r
\name{makeGrid}
\alias{makeGrid}
\title{Make a grid}
\usage{
makeGrid(
  poly,
  gridSize,
  hexGrid = TRUE,
  offset = NULL,
  buffer = FALSE,
  simplify = FALSE,
  tol = 0.01
)
}
\arguments{
\item{poly}{an object of class \sQuote{sf},  \sQuote{SpatialPolygon} or
\sQuote{SpatialPolygonDataFrame}}

\item{gridSize}{width of the cells in Km. It defines the central assumption
of this package that is the maximum area a person can explore during a day.
Be aware, that the spatial extent of a visit is dependent on the taxonomic
group, and many other variables. Maximum recommended for this package 10 km
if there is no reliable definition for the spatial extent for visits.}

\item{hexGrid}{shall the grid cells be hexagonal? Then \code{TRUE} (default).
Else squared grid cells.}

\item{offset}{numeric of length 2 with lower left corner coordinates (x, y)
of the grid. If it is left empty (\code{NULL}, default), then takes default
values \code{st_bbox(x)[c("xmin", "ymin")]}.}

\item{buffer}{shall the grid cells include the polygon border? Then \code{TRUE}
(default = \code{FALSE}).}

\item{simplify}{simplifies the polygon geometry. Complicated polygons (those
with much detail) make this function run slower.}

\item{tol}{numerical tolerance value for the simplification algorithm. Set to
0.01 as default.}
}
\value{
an object of class \sQuote{sf} with a set of polygons conforming to a
grid of equal-area cells, with geodesic coordinates in WGS84 (ESPG:4326).
}
\description{
Makes a grid adapted to the purpose of this package and simplifying options
from the  \code{sf} package. The central concept of the BIRDS package is the
definition of the field visit, and most likely, your grid size will define the
maximum area a person can explore during a day. Use the function
\code{exploreVisits()} to assess if your definition of visit aligns with your
 grid size.
}
\note{
Depending on the total number of grid cells the computations may take
time. If there are more than 500 cells on any dimension a warning message will
be displayed. Grid cells must be smaller than the sampling area. If the grid
cell size is wider than the polygon on any dimension an error message will be
displayed.
}
\examples{
\donttest{
grid <- makeGrid(gotaland, gridSize = 10)
}
}
\seealso{
\code{\link{drawPolygon}}, \code{\link{renameGrid}}, \code{\link{OB2Polygon}}, \code{\link{exploreVisits}}
}
