% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focalSpecies.R
\name{focalSpSummary}
\alias{focalSpSummary}
\title{Summarize records of a species among all visits}
\usage{
focalSpSummary(x, focalSp = NULL)
}
\arguments{
\item{x}{an object of class \sQuote{SummarizeBirds}.}

\item{focalSp}{the focal sp to look for.}
}
\value{
a \code{data.frame} with summary data for the focal species
}
\description{
A function to summarise records of a species among all visits. Returns number of grid cells with occurrences,
number of observations, number of visits, number of years and number of months with occurrences.
}
\examples{
\donttest{
OB <- organizeBirds(bombusObsShort, sppCol = "scientificName", simplifySppName = TRUE)
grid <- makeGrid(searchPolygon, gridSize = 10)
SB <- summariseBirds(OB, grid=grid)
allSpp <- listSpecies(SB)
focal <- "Bombus campestris"
focalSpSummary(SB, focalSp=focal)
}
}
\seealso{
\code{\link{summarizeBirds}}, \code{\link{exportBirds}}
}
