% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpPedigree.R
\name{markPotentialChildren}
\alias{markPotentialChildren}
\title{Mark and Assign children}
\usage{
markPotentialChildren(df_Ngen, i, Ngen, sizeGens, CoupleF)
}
\arguments{
\item{df_Ngen}{A data frame for the current generation being processed.
It must include columns for individual IDs (`id`), spouse IDs (`spID`), sex (`sex`),
and any previously assigned roles (`ifparent`, `ifson`, `ifdau`).}

\item{i}{Integer, the index of the current generation being processed.}

\item{Ngen}{Integer, the total number of generations in the simulation.}

\item{sizeGens}{Numeric vector, containing the size (number of individuals) of each generation.}

\item{CoupleF}{Integer, IT MIGHT BE the number of couples in the current generation.}
}
\value{
Modifies `df_Ngen` in place by updating or adding columns related to individual roles
        (`ifparent`, `ifson`, `ifdau`) and couple IDs (`coupleId`). The updated data frame is
        also returned for integration into the larger pedigree data frame (`df_Fam`).
}
\description{
This subfunction marks individuals in a generation as potential sons, daughters,
or parents based on their relationships and assigns unique couple IDs. It processes
the assignment of roles and relationships within and between generations in a pedigree simulation.
}
