% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_search.R
\name{ggm_search}
\alias{ggm_search}
\title{Search Algorithm}
\usage{
ggm_search(
  x,
  n = NULL,
  method = "mc3",
  prior_prob = 0.1,
  iter = 5000,
  stop_early = 1000,
  bma_mean = TRUE,
  seed = 1,
  progress = TRUE,
  ...
)
}
\arguments{
\item{x}{Either a \code{n} by \code{p} data matrix or a \code{p} by \code{p} correlation matrix.}

\item{n}{Numeric. Sample size. This is required if \code{x} is a correlation matrix.}

\item{method}{Character string. Which search algorithm should be used? The default is
MCMC model composition \insertCite{madigan1994model}{BGGM}.}

\item{prior_prob}{Numeric. Prior inclusion probability for an individual edge. The default is
\code{0.1} which favors graphs with less edges. If \code{prior_prob = 0.5}, this results
in equal prior model probabilities.}

\item{iter}{Numeric. The number of iterations (defaults to 5,000). Note that this is not the
number of posterior samples, but the number of proposed graphs.}

\item{stop_early}{Numeric. Should the sampler be stopped early when the graph does not change? The
default is \code{1000} (i.e., if 1000 graphs have been
rejected in a row, the search stops early).}

\item{bma_mean}{Logical. Should the Bayesian model averaged mean be computed (defaults to \code{TRUE})?}

\item{seed}{An integer for the random seed (defaults to 1).}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ?}

\item{...}{Currently ignored.}
}
\value{
A list of class \code{ggm_search}. For users of \strong{BGGM}, the following
        are the useful objects:

\itemize{

\item \code{pcor_adj} Selected partial correlation matrix (weighted adjacency). This corresponds
                      to the most probable model.

\item \code{Theta_map} Selected precision matrix. This corresponds
                      to the most probable model.

\item \code{Theta_bma} Bayesian model averaged precision matrix

\item \code{pcor_bma} Bayesian model averaged partial correlation matrix.

}
}
\description{
Search the data for promising graphs. In the case of model uncertainty,
Bayesian model averaging is employed.
}
\details{
The algorithm does not scale particularly well with \code{p} (the number of nodes).
}
\examples{
\donttest{

# data
Y <- ptsd

# polychoric partials
S <- psych::polychoric(Y)$rho

# fit model
fit <- ggm_search(x = S,
                  n  = nrow(Y),
                  stop_early = 1000,
                  progress = FALSE)
}
}
\references{
\insertAllCited{}
}
