% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{iri}
\alias{iri}
\title{Interpersonal Reactivity Index (IRI)}
\format{A data frame with 28 variables and 1973 observations (5 point Likert scale)}
\usage{
data("iri")
}
\description{
A dataset containing items from the Interpersonal Reactivity Index (IRI; an empathy measure). There are 28 variables  and
1973 observations
}
\details{
\itemize{
  \item \code{1} I daydream and fantasize, with some regularity, about things that might happen to me.
  \item \code{2}  I often have tender, concerned feelings for people less fortunate than me.
  \item \code{3} I sometimes find it difficult to see things from the "other guy's" point of view.
  \item \code{4} Sometimes I don't feel very sorry for other people when they are having problems.
  \item \code{5}  I really get involved with the feelings of the characters in a novel.
  \item \code{6} In emergency situations, I feel apprehensive and ill-at-ease.
  \item \code{7}  I am usually objective when I watch a movie or play, and I don't often get completely caught up in it.
  \item \code{8} I try to look at everybody's side of a disagreement before I make a decision.
  \item \code{9}  When I see someone being taken advantage of, I feel kind of protective towards them.
  \item \code{10} I sometimes feel helpless when I am in the middle of a very emotional situation.
  \item \code{11}  I sometimes try to understand my friends better
  by imagining how things look from their perspective
  \item \code{12} Becoming extremely involved in a good book or movie is somewhat rare for me.
  \item \code{13} When I see someone get hurt, I tend to remain calm.
  \item \code{14} Other people's misfortunes do not usually disturb me a great deal.
  \item \code{15}  If I'm sure I'm right about something, I don't waste much
  time listening to other people's arguments.
  \item \code{16}  After seeing a play or movie, I have felt as though I were one of the characters.
  \item \code{17}  Being in a tense emotional situation scares me.
  \item \code{18}  When I see someone being treated unfairly,
  I sometimes don't feel very much pity for them.
  \item \code{19} I am usually pretty effective in dealing with emergencies.
  \item \code{20} I am often quite touched by things that I see happen.
  \item \code{21} I believe that there are two sides to every question and try to look at them both.
  \item \code{22} I would describe myself as a pretty soft-hearted person.
  \item \code{23} When I watch a good movie, I can very easily put myself in
  the place of a leading character
  \item \code{24}  I tend to lose control during emergencies.
  \item \code{25} When I'm upset at someone, I usually try to "put myself in his shoes" for a while.
  \item \code{26} When I am reading an interesting story or novel, I imagine how I would feel if the
  events in the story were happening to me.
  \item \code{27}  When I see someone who badly needs help in an emergency, I go to pieces.
  \item \code{28} Before criticizing somebody, I try to imagine how I would feel if I were in their place.
  \item \code{gender} "M" (male) or "F" (female)

}
}
\note{
There are four domains

Fantasy: items 1, 5, 7, 12, 16, 23, 26

Perspective taking: items 3, 8, 11, 15, 21, 25, 28

Empathic concern: items 2, 4, 9, 14, 18, 20, 22

Personal distress: items 6, 10, 13, 17, 19, 24, 27,
}
\examples{
data("iri")

# labels
iri_labels <- BGGM:::iri_labels
}
\references{
Briganti, G., Kempenaers, C., Braun, S., Fried, E. I., & Linkowski, P. (2018). Network analysis of
empathy items from the interpersonal reactivity index in 1973
young adults. Psychiatry research, 265, 87-92.
}
\keyword{datasets}
