% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_fixed_number_changepoints.R
\name{infer_fixed_changepoints}
\alias{infer_fixed_changepoints}
\title{Inferring the change-points locations when the number of change-points is fixed.}
\usage{
infer_fixed_changepoints(
  input_data,
  l,
  depth,
  alphabet,
  iters,
  fileName = NULL
)
}
\arguments{
\item{input_data}{the sequence to be analysed.}

\item{l}{number of change-points.}

\item{depth}{maximum memory length.}

\item{alphabet}{symbols appearing in the sequence.}

\item{iters}{number of iterations; for more information see \href{https://arxiv.org/pdf/2203.04341.pdf}{Lungu et al. (2022)}.}

\item{fileName}{file path for storing the results.}
}
\value{
return a list object which includes:
\item{positions}{the sampled locations of the change-points.}
\item{acceptance_prob}{the empirical acceptance ratio.}
}
\description{
This function implements the Metropolis-Hastings sampling algorithm for inferring the locations of the change-points.
}
\examples{
# Use as an example the three_changes dataset.
# Run the function with 3 change-points, a maximum depth of 5 and the [0,1,2] alphabet.
# The sampler is run for 100 iterations
output <- infer_fixed_changepoints(three_changes, 3, 5, c("012"), 100, fileName = NULL)

# If the fileName is not set to NULL, 
# the output file will contain on each line the sampled locations of the change-points.
}
\seealso{
\code{\link{infer_unknown_changepoints}}
}
