% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{run_query}
\alias{run_query}
\title{Run a query or command against a Kusto database}
\usage{
run_query(database, qry_cmd, ..., .http_status_handler = "stop")
}
\arguments{
\item{database}{A Kusto database endpoint object, as returned by \code{kusto_database_endpoint}.}

\item{qry_cmd}{A string containing the query or command. In KQL, a database management command is a statement that starts with a "."}

\item{...}{Named arguments to be used as parameters for a parameterized query. These are ignored for database management commands.}

\item{.http_status_handler}{The function to use to handle HTTP status codes. The default "stop" will throw an R error via \code{httr::stop_for_status} if the status code is not less than 300; other possibilities are "warn", "message" and "pass". The last option will pass through the raw response object from the server unchanged, regardless of the status code. This is mostly useful for debugging purposes, or if you want to see what the Kusto REST API does.}
}
\description{
Run a query or command against a Kusto database
}
\details{
This function is the workhorse of the AzureKusto package. It communicates with the Kusto server and returns the query or command results, as data frames.
}
\examples{
\dontrun{

endp <- kusto_database_endpoint(server="myclust.australiaeast.kusto.windows.net", database="db1")

# a command
run_query(endp, ".show table iris")

# a query
run_query(endp, "iris | count")

}
}
\seealso{
\link{kusto_database_endpoint}, \link{ingest_local}, \link{ingest_url}, \link{ingest_blob}, \link{ingest_adls2}
}
