% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi.R
\docType{methods}
\name{dbGetQuery,AzureKustoConnection,character-method}
\alias{dbGetQuery,AzureKustoConnection,character-method}
\alias{dbSendQuery,AzureKustoConnection-method}
\alias{dbFetch,AzureKustoResult-method}
\alias{dbSendStatement,AzureKustoConnection,character-method}
\alias{dbExecute,AzureKustoConnection,character-method}
\alias{dbListFields,AzureKustoConnection,character-method}
\alias{dbColumnInfo,AzureKustoResult-method}
\title{DBI methods for Kusto queries and commands}
\usage{
\S4method{dbGetQuery}{AzureKustoConnection,character}(conn, statement, ...)

\S4method{dbSendQuery}{AzureKustoConnection}(conn, statement, ...)

\S4method{dbFetch}{AzureKustoResult}(res, n = -1, ...)

\S4method{dbSendStatement}{AzureKustoConnection,character}(conn, statement,
  ...)

\S4method{dbExecute}{AzureKustoConnection,character}(conn, statement, ...)

\S4method{dbListFields}{AzureKustoConnection,character}(conn, name, ...)

\S4method{dbColumnInfo}{AzureKustoResult}(res, ...)
}
\arguments{
\item{conn}{An AzureKustoConnection object.}

\item{statement}{A string containing a Kusto query or control command.}

\item{...}{Further arguments passed to \code{run_query}.}

\item{res}{An AzureKustoResult resultset object}

\item{n}{The number of rows to return. Not used.}

\item{name}{For \code{dbListFields}, a table name.}
}
\description{
DBI methods for Kusto queries and commands
}
\details{
These are the basic DBI functions to query the database. Note that Kusto only supports synchronous queries and commands; in particular, \code{dbSendQuery} and \code{dbSendStatement} will wait for the query or statement to complete, rather than returning immediately.

\code{dbSendStatement} and \code{dbExecute} are meant for running Kusto control commands, and will throw an error if passed a regular query. \code{dbExecute} also returns the entire result of running the command, rather than simply a row count.
}
\examples{
\dontrun{

db <- DBI::dbConnect(AzureKusto(),
    server="https://mycluster.location.kusto.windows.net", database="database"...)

DBI::dbGetQuery(db, "iris | count")
DBI::dbListFields(db, "iris")

# does the same thing as dbGetQuery, but returns an AzureKustoResult object
res <- DBI::dbSendQuery(db, "iris | count")
DBI::dbFetch(res)
DBI::dbColumnInfo(res)

DBI::dbExecute(db, ".show tables")

# does the same thing as dbExecute, but returns an AzureKustoResult object
res <- DBI::dbSendStatement(db, ".show tables")
DBI::dbFetch(res)

}
}
\seealso{
\link{dbConnect}, \link{dbReadTable}, \link{dbWriteTable}, \link{run_query}
}
