% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{PhasesMCMC-class}
\alias{PhasesMCMC-class}
\alias{.PhasesMCMC}
\title{MCMC Phases}
\description{
S4 classes to represent a collection of phases.
}
\details{
A phase object is an\eqn{n x m x 2}{n \times m \times 2} array, with
\eqn{n} being the number of iterations, \eqn{m} being the number of phases
and with the 2 columns of the third dimension containing the boundaries of
the phases.
}
\section{Slots}{

\describe{
\item{\code{labels}}{A \code{\link{character}} vector specifying the name of the phases.}

\item{\code{hash}}{A \code{\link{character}} string giving the 32-byte MD5 hash of the
original data file.}
}}

\note{
This class inherits from \code{\link{array}}.
}
\section{Subset}{

In the code snippets below, \code{x} is a \code{PhasesMCMC} object.
\describe{
\item{\code{x[[i]]}}{Extracts a single phase (two chains) selected by subscript
\code{i}. \code{i} is a length-one \code{\link{numeric}} or \code{\link{character}} vector.}
}
}

\seealso{
Other classes: 
\code{\link{ActivityEvents-class}},
\code{\link{AgeDepthModel-class}},
\code{\link{CumulativeEvents-class}},
\code{\link{DurationsMCMC-class}},
\code{\link{EventsMCMC-class}},
\code{\link{MCMC-class}},
\code{\link{OccurrenceEvents-class}},
\code{\link{TimeRange-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
