% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllenPlot.R
\name{allen_plot}
\alias{allen_plot}
\title{Make a single plot of a Nökel lattice.}
\usage{
allen_plot(
  allen_set,
  file_name = NULL,
  pad = 0.2,
  font_size = 11,
  height = 7,
  width = 7,
  columns = 1,
  plot_title = allen_set$title,
  dpi = 600
)
}
\arguments{
\item{allen_set}{a dataframe with plot information, such as the one
produced by \code{illustrate_allen_relations()}}

\item{file_name}{optional path to the graphic file output}

\item{pad}{padding in inches to the margins to keep
labels from disappearing off the edge of the graphic (default 0.2)}

\item{font_size}{font size for the labels in the plot (default 11)}

\item{height}{height in inches of the graphic file output (default 7)}

\item{width}{width in inches of the graphic file output (default 7)}

\item{columns}{number of columns for a plot with more than one lattice (default 1)}

\item{plot_title}{title for the plot, defaults to the title in \code{allen_set}}

\item{dpi}{dots per inch for bitmap files (default 600)}
}
\value{
Typically called for its side effects, returns \code{allen_set}
}
\description{
Plots a Nökel lattice to the display and optionally to a file.
}
\author{
Thomas S. Dye
}
