% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempoPlot.R
\name{TempoPlot}
\alias{TempoPlot}
\title{Tempo plot}
\usage{
TempoPlot(
  data,
  position,
  plot.result = NULL,
  level = 0.95,
  count = TRUE,
  Gauss = FALSE,
  title = "Tempo plot",
  subtitle = NULL,
  caption = "ArcheoPhases",
  legend.title = "Legend",
  legend.labels = c("Bayes estimate", "Credible interval, low",
    "Credible interval, high", "Gaussian approx., high", "Gaussian approx., low"),
  x.label = "Calendar year",
  y.label = "Cumulative events",
  line.types = c("solid", "12", "11", "28", "28"),
  width = 7,
  height = 7,
  units = "in",
  x.min = NULL,
  x.max = NULL,
  colors = TRUE,
  file = NULL,
  x.scale = "calendar",
  elapsed.origin.position = NULL,
  newWindow = TRUE,
  print.data.result = FALSE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest.}

\item{plot.result}{List containing the data to plot,
typically the result of a previous run of \code{TempoPlot()}.}

\item{level}{Probability corresponding to the level of confidence.}

\item{count}{If \code{TRUE} the counting process is a number,
otherwise it is a probability.}

\item{Gauss}{If \code{TRUE}, the Gaussian approximation of the
credible interval is used.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{legend.title}{Title of the plot legend.}

\item{legend.labels}{Vector of strings to label legend entries.}

\item{x.label}{Label of the x-axis.}

\item{y.label}{Label of the y-axis.}

\item{line.types}{Type of the lines drawn on the plot in the order
of \code{legend.labels}.}

\item{width}{Width of the plot in \code{units}.}

\item{height}{Height of the plot in \code{units}.}

\item{units}{Units used to specify \code{width} and \code{height},
one of "in" (default), "cm", or "mm".}

\item{x.min}{Minimum value for x-axis.}

\item{x.max}{Maximum value for x-axis.}

\item{colors}{If \code{TRUE}, the plot is drawn with colors,
otherwise it is drawn in black and white.}

\item{file}{Name of the file that will be saved if specified.
If \code{NULL} no file is saved.}

\item{x.scale}{One of "calendar", "bp", or "elapsed".}

\item{elapsed.origin.position}{If \code{x.scale} is "elapsed", the position
of the column corresponding to the event from which elapsed time is
calculated.}

\item{newWindow}{Whether or not the plot is drawn within a new window.}

\item{print.data.result}{If \code{TRUE}, a list containing the data to plot
will be returned.}
}
\value{
\code{NULL}, called for its side effects.  It may also return a list containing the
data to plot (if \code{print.data.result = TRUE}).
}
\description{
A statistical graphic designed for the archaeological study of
rhythms of the long term that embodies a theory of archaeological
evidence for the occurrence of events
}
\details{
The tempo plot is one way to measure change over time: it estimates the cumulative occurrence
of archaeological events in a Bayesian calibration.  The tempo plot yields a graphic where
the slope of the plot directly reflects the pace of change: a period of rapid change
yields a steep slope and a period of slow change yields a gentle slope. When there is no
change, the plot is horizontal. When change is instantaneous, the plot is vertical.
}
\examples{
  data(Events);
  TempoPlot(Events[1:1000, ], c(2:5), print.data.result = FALSE)
  TempoPlot(Events[1:1000, ], c(2:5), count = TRUE,  print.data.result = FALSE)

}
\references{
Dye, T.S. (2016) Long-term rhythms in the development of Hawaiian social stratification.
Journal of Archaeological Science, 71, 1--9
}
\seealso{
\code{\link{tempo_plot}}
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Thomas S. Dye, \email{tsd@tsdye.online}, and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
