% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuccessionPlot.R
\name{SuccessionPlot}
\alias{SuccessionPlot}
\title{Density plots of two successive groups (for groups in temporal order constraint)}
\usage{
SuccessionPlot(
  Phase1Min_chain,
  Phase1Max_chain,
  Phase2Min_chain,
  Phase2Max_chain,
  level = 0.95,
  title = "Characterisation of a succession of groups",
  exportFile = NULL,
  exportFormat = "PNG",
  GridLength = 1024
)
}
\arguments{
\item{Phase1Min_chain}{Numeric vector containing the output of the MCMC
algorithm for the minimum of the events included in the oldest phase.}

\item{Phase1Max_chain}{Numeric vector containing the output of the MCMC
algorithm for the maximum of the events included in the oldest phase.}

\item{Phase2Min_chain}{Numeric vector containing the output of the MCMC
algorithm for the minimum of the events included in the youngest phase.}

\item{Phase2Max_chain}{Numeric vector containing the output of the MCMC
algorithm for the maximum of the events included in the youngest phase.}

\item{level}{Probability corresponding to the level of confidence.}

\item{title}{Title of the plot.}

\item{exportFile}{Name of the file to be saved.
If \code{NULL} then no plot is saved.}

\item{exportFormat}{Format of the export file, either "PNG" or "SVG".}

\item{GridLength}{Length of the grid used to estimate the density.}
}
\value{
\code{NULL}, called for its side effects
}
\description{
Plot of the densities of the minimum and the maximum of the events included
in each group, with summary statistics including the mean, credible interval,
and highest posterior density. The result is given in calendar years (BC/AD).
}
\details{
Curves represent the density of the minimum (oldest event) and the maximum
(youngest event) of the events included in each group. Curves of the same
color refer to the same group. Time range intervals are symbolised by
segments above the curves drawn using the same color as curves of the
associated group. Transition and gap range intervals are represented by
two-coloured segments using the colors of the both groups in succession.
If the gap between the successive groups does not exist, a cross is drawn
instead of a segment.
}
\examples{
  data(Phases); attach(Phases)
  SuccessionPlot(Phase.1.alpha, Phase.1.beta, Phase.2.alpha, Phase.2.beta, level = 0.95)


}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
