% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhasesTransition.R
\name{PhasesTransition}
\alias{PhasesTransition}
\title{Transition range between two successive phases (for phases in temporal order constraint)}
\usage{
PhasesTransition(Phase1Max_chain, Phase2Min_chain, level = 0.95)
}
\arguments{
\item{Phase1Max_chain}{Numeric vector containing the output of the
MCMC algorithm for the maximum of the events included in the oldest phase.}

\item{Phase2Min_chain}{Numeric vector containing the output of the
MCMC algorithm for the minimum of the events included in the following phase.}

\item{level}{Probability corresponding to the level of confidence.}
}
\value{
a vector of values containing the level of confidence and the
endpoints of the transition interval between the successive phases.
The result is given in calendar years (BC/AD).
}
\description{
Finds, if it exists, the shortest interval that satisfies
\eqn{P(TransitionRangeInf < Phase1Max_chain < Phase2Min_chain < TransitionRangeSup  | M) = level}
}
\examples{
  data(Phases); attach(Phases)
  PhasesTransition(Phase.1.beta, Phase.2.alpha, 0.95)
  PhasesTransition(Phase.1.beta, Phase.2.alpha, 0.50)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
