## The information in this file can be accessed with 'package?ArchaeoPhases'
##
#' ArchaeoPhases: Post-Processing of the Markov Chain Simulated by 'Chronomodel',
#' 'OxCal', or 'BCal'.
#'
#' Provides a list of functions for the statistical analysis of archaeological
#' dates and groups of dates. It is based on the post-processing of the Markov
#' Chains whose stationary distribution is the posterior distribution of a
#' series of dates. Such output can be simulated by different applications,
#' as for instance
#' \href{https://chronomodel.com/}{ChronoModel},
#' \href{https://c14.arch.ox.ac.uk/oxcal.html}{OxCal}, or
#' \href{https://bcal.shef.ac.uk/}{BCal}.
#' The only requirement is to have a csv file containing a sample from the
#' posterior distribution.
#'
#' @docType package
#' @name ArchaeoPhases
NULL
