% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_get_sequences.R
\name{Af_get_sequences}
\alias{Af_get_sequences}
\title{Function to get the sequences from the nodes in an AntibodyForest object}
\usage{
Af_get_sequences(AntibodyForests_object, sequence.name, min.nodes, min.edges)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests-object, output from Af_build()}

\item{sequence.name}{character, name of the sequence column in the AntibodyForests object (example VDJ_sequence_aa_trimmed)}

\item{min.nodes}{integer, minimum number of nodes in the tree (not including germline)}

\item{min.edges}{integer, minimum number of edges in the tree (not including edges to the germline)}
}
\value{
A dataframe with the sequences and sequence identifiers
}
\description{
Function to get the sequences from the nodes in an AntibodyForest object
}
\examples{
sequence_df <- Af_get_sequences(AntibodyForests::small_af,
               sequence.name = "VDJ_sequence_aa_trimmed")
}
