% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADP.R
\name{ptriers}
\alias{ptriers}
\title{Calculates the predicted prevalence of triers according to the users' rate}
\source{
Kislev, Mickey M. & Kislev, Shira, (2020). The Market Trajectory of a
Radically New Product: E-Cigarettes. IJMS 12(4):63-92, DOI:\href{https://www.ccsenet.org/journal/index.php/ijms/article/view/0/44285}{10.5539/ijms.v12n4p63}
}
\usage{
ptriers(users)
}
\arguments{
\item{users}{a vector of percentige (0<users<1) of known users.}
}
\value{
a vector of predicted percentige(0<triers<1) of triers in the population of a certain innovation according to known users rate
}
\description{
This function develops a prediction of the triers' rate of an innovation in
the market, according to the number of users.
}
\details{
This function calculates the rate of triers in the population of a certain
innovation according to known users rate in that population and measured in a survey.
}
\examples{
# 50\% rate of users
ptriers(0.5)
0.7382
# means that 74\% of the population tried the product
}
\seealso{
\code{\link{pusers}}, \code{\link{adp.t}}, and \code{\link{adp.u}}
}
\author{
Mickey Kislev and Shira Kislev
}
