% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide.R
\name{explicit_guide.yamlet}
\alias{explicit_guide.yamlet}
\title{Coerce Yamlet Guide to Something More Explicit}
\usage{
\method{explicit_guide}{yamlet}(
  x,
  ...,
  test = getOption("yamlet_infer_guide", yamlet::infer_guide),
  expand = getOption("yamlet_expand_codelist", TRUE),
  data = NULL
)
}
\arguments{
\item{x}{yamlet}

\item{...}{passed to \code{\link[dplyr]{select}} to limit scope}

\item{test}{function or function name; supply non-default or globally set \code{options(yamlet_infer_guide = )}.}

\item{expand}{whether to expand empty guide list using sorted unique values. NA likely excluded.}

\item{data}{optional data.frame for testing guides with length > 1}
}
\value{
yamlet
}
\description{
Coerces yamlet 'guide' keys to something more explicit.
The key 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace 'guide' with something
explicit in case required downstream.
}
\details{
If \code{data} is supplied, guides that are lists
are checked to see if they evaluate to conditions in data context
(see \code{\link{isConditional.list}}).
If so, inferences are based on the first guide element rather
than the guide as a whole.

This method iterates across the guide elements, renaming them
as specified by the value of \code{test}. (default: \code{\link{infer_guide}}).
\code{test} should be a function (or name of one) that accepts x, data, and dots.
If a data.frame is passed to explicit_guide(), the relevant column will
be passed as data to \code{test}.
}
\examples{
library(magrittr)
'CONC: [ concentration, µg/mL ]' \%>\% as_yamlet \%>\% explicit_guide
'RACE: [ subject race, [ Caucasian: 0, Latin: 1, Black: 2 ]]' \%>\% as_yamlet \%>\% explicit_guide
'RACE: [ subject race, [ Caucasian, Latin, Black ]]' \%>\% as_yamlet \%>\% explicit_guide
'RACE: [ subject race, //0/Caucasian//1/Latin//2/Black// ]' \%>\% as_yamlet \%>\% explicit_guide
'DATE: [ date, "\%Y-\%m-\%d" ]' \%>\% as_yamlet \%>\% explicit_guide
'PRSE: [ standard error, "\%" ]' \%>\% as_yamlet \%>\% explicit_guide

}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide.dvec}()},
\code{\link{explicit_guide.factor}()},
\code{\link{implicit_guide}()},
\code{\link{implicit_guide.data.frame}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{implicit_guide.factor}()},
\code{\link{infer_guide}()}
}
\concept{explicit_guide}
\keyword{internal}
