# xlr_numeric.format prints the way we want it

    Code
      xlr_numeric(1:100 / 100)
    Output
      <xlr_numeric[100]>
        [1] 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.11 0.12 0.13 0.14 0.15
       [16] 0.16 0.17 0.18 0.19 0.20 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.30
       [31] 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.40 0.41 0.42 0.43 0.44 0.45
       [46] 0.46 0.47 0.48 0.49 0.50 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.60
       [61] 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.70 0.71 0.72 0.73 0.74 0.75
       [76] 0.76 0.77 0.78 0.79 0.80 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.90
       [91] 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99 1.00

---

    Code
      xlr_numeric(0:99 / 100, dp = 2)
    Output
      <xlr_numeric[100]>
        [1] 0.00 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.11 0.12 0.13 0.14
       [16] 0.15 0.16 0.17 0.18 0.19 0.20 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29
       [31] 0.30 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.40 0.41 0.42 0.43 0.44
       [46] 0.45 0.46 0.47 0.48 0.49 0.50 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59
       [61] 0.60 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.70 0.71 0.72 0.73 0.74
       [76] 0.75 0.76 0.77 0.78 0.79 0.80 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89
       [91] 0.90 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99

---

    Code
      tibble::tibble(test = xlr_numeric(0:99 / 100, dp = 2))
    Output
      # A tibble: 100 x 1
            test
         <x_num>
       1    0.00
       2    0.01
       3    0.02
       4    0.03
       5    0.04
       6    0.05
       7    0.06
       8    0.07
       9    0.08
      10    0.09
      # i 90 more rows

# xlr_numeric.format prints using scientific notation like we want it

    Code
      xlr_numeric(1:100 / 100, dp = 0, scientific = TRUE)
    Output
      <xlr_numeric[100]>
        [1] 1e-02 2e-02 3e-02 4e-02 5e-02 6e-02 7e-02 8e-02 9e-02 1e-01 1e-01 1e-01
       [13] 1e-01 1e-01 2e-01 2e-01 2e-01 2e-01 2e-01 2e-01 2e-01 2e-01 2e-01 2e-01
       [25] 2e-01 3e-01 3e-01 3e-01 3e-01 3e-01 3e-01 3e-01 3e-01 3e-01 4e-01 4e-01
       [37] 4e-01 4e-01 4e-01 4e-01 4e-01 4e-01 4e-01 4e-01 4e-01 5e-01 5e-01 5e-01
       [49] 5e-01 5e-01 5e-01 5e-01 5e-01 5e-01 6e-01 6e-01 6e-01 6e-01 6e-01 6e-01
       [61] 6e-01 6e-01 6e-01 6e-01 6e-01 7e-01 7e-01 7e-01 7e-01 7e-01 7e-01 7e-01
       [73] 7e-01 7e-01 8e-01 8e-01 8e-01 8e-01 8e-01 8e-01 8e-01 8e-01 8e-01 8e-01
       [85] 8e-01 9e-01 9e-01 9e-01 9e-01 9e-01 9e-01 9e-01 9e-01 9e-01 1e+00 1e+00
       [97] 1e+00 1e+00 1e+00 1e+00

---

    Code
      xlr_numeric(0:99 / 100, dp = 2, scientific = TRUE)
    Output
      <xlr_numeric[100]>
        [1] 0.00e+00 1.00e-02 2.00e-02 3.00e-02 4.00e-02 5.00e-02 6.00e-02 7.00e-02
        [9] 8.00e-02 9.00e-02 1.00e-01 1.10e-01 1.20e-01 1.30e-01 1.40e-01 1.50e-01
       [17] 1.60e-01 1.70e-01 1.80e-01 1.90e-01 2.00e-01 2.10e-01 2.20e-01 2.30e-01
       [25] 2.40e-01 2.50e-01 2.60e-01 2.70e-01 2.80e-01 2.90e-01 3.00e-01 3.10e-01
       [33] 3.20e-01 3.30e-01 3.40e-01 3.50e-01 3.60e-01 3.70e-01 3.80e-01 3.90e-01
       [41] 4.00e-01 4.10e-01 4.20e-01 4.30e-01 4.40e-01 4.50e-01 4.60e-01 4.70e-01
       [49] 4.80e-01 4.90e-01 5.00e-01 5.10e-01 5.20e-01 5.30e-01 5.40e-01 5.50e-01
       [57] 5.60e-01 5.70e-01 5.80e-01 5.90e-01 6.00e-01 6.10e-01 6.20e-01 6.30e-01
       [65] 6.40e-01 6.50e-01 6.60e-01 6.70e-01 6.80e-01 6.90e-01 7.00e-01 7.10e-01
       [73] 7.20e-01 7.30e-01 7.40e-01 7.50e-01 7.60e-01 7.70e-01 7.80e-01 7.90e-01
       [81] 8.00e-01 8.10e-01 8.20e-01 8.30e-01 8.40e-01 8.50e-01 8.60e-01 8.70e-01
       [89] 8.80e-01 8.90e-01 9.00e-01 9.10e-01 9.20e-01 9.30e-01 9.40e-01 9.50e-01
       [97] 9.60e-01 9.70e-01 9.80e-01 9.90e-01

---

    Code
      tibble::tibble(test = xlr_numeric(0:99 / 100, dp = 4, scientific = TRUE))
    Output
      # A tibble: 100 x 1
               test
            <x_num>
       1 0.0000e+00
       2 1.0000e-02
       3 2.0000e-02
       4 3.0000e-02
       5 4.0000e-02
       6 5.0000e-02
       7 6.0000e-02
       8 7.0000e-02
       9 8.0000e-02
      10 9.0000e-02
      # i 90 more rows

# vec_ptype2.xlr_percent.xlr_percent raises warning when things don't match

    Code
      c(xlr_numeric(1), xlr_numeric(1, dp = 3))
    Condition
      Warning:
      Attributes ("dp", "scientific", or "style) do not match, taking the attributes from the left-hand side.
    Output
      <xlr_numeric[2]>
      [1] 1.00 1.00

# vec_arith.xlr_percent.xlr_percent raises warning when things don't match

    Code
      xlr_numeric(1) + xlr_numeric(1, dp = 3)
    Condition
      Warning:
      Attributes ("dp", "scientific", or "style) do not match, taking the attributes from the left-hand side.
    Output
      <xlr_numeric[1]>
      [1] 2.00

