% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelinesInGene.R
\name{newPipelineG}
\alias{newPipelineG}
\title{Converts a gene into a gene with genetic operator pipeline.}
\usage{
newPipelineG(g)
}
\arguments{
\item{g}{A gene.}
}
\value{
A gene with embedded genetic operator pipeline  
        without mutation and crossover.
        The argument \code{lF} of the function \code{$Pipeline}
        configures the behavior of the pipeline.
}
\description{
The pipeline is \code{evaluate(gene)}.
}
\details{
\code{newPipelineG} is a constructor 
         which integrates a genetic operator pipeline which 
         contains the evaluation of a gene into a gene.
}
\examples{
g<-xegaGaInitGene(lFxegaGaGene)
a<-newPipelineG(g)
print(a)
b<-a$Pipeline(a, lFxegaGaGene)
print(b)
}
\seealso{
Other Genetic Operator Pipelines in Gene: 
\code{\link{newCross2Mut1PipelineG}()},
\code{\link{newCross2Mut2PipelineG}()},
\code{\link{newCross2PipelineG}()},
\code{\link{newCrossMut2PipelineG}()},
\code{\link{newCrossMutPipelineG}()},
\code{\link{newCrossPipelineG}()},
\code{\link{newMutPipelineG}()}
}
\concept{Genetic Operator Pipelines in Gene}
