% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_and_process_e4.R
\name{join_eda_bin}
\alias{join_eda_bin}
\title{Join EDA Binary Classifier Output to Dataset}
\usage{
join_eda_bin(data, eda_bin)
}
\arguments{
\item{data}{A data frame containing the main dataset with a 'DateTime' column 
that represents timestamps.}

\item{eda_bin}{A data frame containing the EDA binary classifier outputs, including 
an 'id' column that represents timestamps. This data frame is expected to merge with 
the main data frame based on these timestamps.}
}
\value{
A data frame that combines the main dataset with the EDA binary classifier 
outputs. The classifier's label is renamed to 'quality_flag'. In cases where a precise 
match for the 5-second interval is not found in the classifier output, NA values 
may be introduced in the 'quality_flag' column.
}
\description{
This function joins the output of an EDA binary classifier to a dataset based on 
rounded 5-second intervals. It is designed to merge two data frames: one containing 
your main data and another containing EDA binary classifier predictions. The function 
ensures that each record in the main data is matched with the appropriate classifier 
output by aligning timestamps to the nearest 5-second interval.
}
\details{
The function first uses `padr::thicken` to extend the main data frame by 
creating a new column 'DateTime_5_sec', which rounds the 'DateTime' values to 5-second 
intervals. Then, it performs a left join with the EDA binary classifier data, which 
has been similarly adjusted using `lubridate::floor_date` to match these intervals. 
After the join, unnecessary columns ('DateTime_5_sec' and 'id') are dropped, and the 
classifier's 'label' column is renamed to 'quality_flag'.
}
\examples{
\dontrun{
  main_data <- data.frame(DateTime = as.POSIXct(...), ...)
  classifier_data <- data.frame(id = as.POSIXct(...), label = ..., ...)
  joined_data <- join_eda_bin(main_data, classifier_data)
}
}
