% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_drug.R
\name{screen_drug}
\alias{screen_drug}
\title{Screening of drugs}
\usage{
screen_drug(.data, mp_data, freq_threshold = NULL, top_n = NULL)
}
\arguments{
\item{.data, }{An \code{drug} data.table. See \code{\link{drug_}}}

\item{mp_data}{An \code{MP} data.table. See \code{\link{mp_}}}

\item{freq_threshold}{A numeric value indicating the minimum
frequency (as a proportion) of cases where a drug must appear
to be included in the results. Defaults to \code{NULL}.}

\item{top_n}{An integer specifying the number of most frequently occurring drugs to return. Defaults to \code{NULL}.}
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \verb{Drug name}: The drug name.
\item \code{DrecNo}: The drug record number
\item \code{N}: The number of unique reports (cases) where the drug appears.
\item \code{percentage}: The percentage of total unique reports
where the drug appears.
}
The results are sorted in descending order of \code{percentage}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
The \code{screen_drug()} function identifies and ranks the most frequently
reported drugs (by active ingredient) in a dataset.
}
\details{
\itemize{
\item If \code{freq_threshold} is set (e.g., \code{0.05}), the function filters
drugs appearing in at least 5\% of unique reports in \code{.data}.
\item If \code{top_n} is specified, only the most frequent \code{n} drugs are returned.
If both \code{freq_threshold} and \code{top_n} are provided, only \code{top_n} is
applied (a warning is raised in such cases).
\item Counts are computed at the \emph{case} level, not the drug mention level.
This means frequencies reflect the proportion of unique
reports (cases) where a drug is mentioned, rather than the total
mentions across all reports.
}
}
\examples{
# Set up start
data.table::setDTthreads(1)

# Filter drugs appearing in at least 10\% of reports
screen_drug(
  .data = drug_,
  mp_data = mp_,
  freq_threshold = 0.10
)

# Get the top 5 most reported drugs
screen_drug(
  .data = drug_,
  mp_data = mp_,
  top_n = 5
)

# nb: in the example datasets, not all drugs are recorded in mp_,
# leading to NAs in screen_drug output.

# Set up end
data.table::setDTthreads(0)
}
