% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice-chop.R
\name{vec_chop}
\alias{vec_chop}
\title{Chopping}
\usage{
vec_chop(x, ..., indices = NULL, sizes = NULL)
}
\arguments{
\item{x}{A vector}

\item{...}{These dots are for future extensions and must be empty.}

\item{indices}{A list of positive integer vectors to slice \code{x} with, or
\code{NULL}. Can't be used if \code{sizes} is already specified. If both \code{indices}
and \code{sizes} are \code{NULL}, \code{x} is split into its individual elements,
equivalent to using an \code{indices} of \code{as.list(vec_seq_along(x))}.}

\item{sizes}{An integer vector of non-negative sizes representing sequential
indices to slice \code{x} with, or \code{NULL}. Can't be used if \code{indices} is already
specified.

For example, \code{sizes = c(2, 4)} is equivalent to \code{indices = list(1:2, 3:6)},
but is typically faster.

\code{sum(sizes)} must be equal to \code{vec_size(x)}, i.e. \code{sizes} must completely
partition \code{x}, but an individual size is allowed to be \code{0}.}
}
\value{
A list where each element has the same type as \code{x}. The size of the list is
equal to \code{vec_size(indices)}, \code{vec_size(sizes)}, or \code{vec_size(x)} depending
on whether or not \code{indices} or \code{sizes} is provided.
}
\description{
\code{vec_chop()} provides an efficient method to repeatedly slice a vector. It
captures the pattern of \code{map(indices, vec_slice, x = x)}. When no indices
are supplied, it is generally equivalent to \code{\link[=as.list]{as.list()}}.
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_slice]{vec_slice()}}
}
}

\examples{
vec_chop(1:5)

# These two are equivalent
vec_chop(1:5, indices = list(1:2, 3:5))
vec_chop(1:5, sizes = c(2, 3))

# Can also be used on data frames
vec_chop(mtcars, indices = list(1:3, 4:6))

# If you know your input is sorted and you'd like to split on the groups,
# `vec_run_sizes()` can be efficiently combined with `sizes`
df <- data_frame(
  g = c(2, 5, 5, 6, 6, 6, 6, 8, 9, 9),
  x = 1:10
)
vec_chop(df, sizes = vec_run_sizes(df$g))

# If you have a list of homogeneous vectors, sometimes it can be useful to
# combine, apply a function to the flattened vector, and chop according
# to the original indices. This can be done efficiently with `list_sizes()`.
x <- list(c(1, 2, 1), c(3, 1), 5, double())
x_flat <- vec_c(!!!x)
x_flat <- x_flat + max(x_flat)
vec_chop(x_flat, sizes = list_sizes(x))
}
