% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{JobSat}
\alias{JobSat}
\title{Cross-classification of job satisfaction by income}
\format{
A 4 x 4 contingency table of \code{income} by \code{satisfaction},
with the following structure:
\preformatted{
  table [1:4, 1:4] 1 2 1 0 3 3 6 1 10 10 ...
  - attr(*, "dimnames")=List of 2
  ..$ income      : chr [1:4] "< 15k" "15-25k" "25-40k" "> 40k"
  ..$ satisfaction: chr [1:4] "VeryD" "LittleD" "ModerateS" "VeryS"
}
}
\source{
Agresti, A. Categorical Data Analysis John Wiley & Sons, 2002, Table
2.8, p. 57.
}
\description{
This data set is a contingency table of job satisfaction by income for a
small sample of black males from the 1996 General Social Survey, as used by
Agresti (2002) for an example.
}
\details{
Both \code{income} and \code{satisfaction} are ordinal variables, and are so
ordered in the table.  Measures of association, visualizations, and models
should take ordinality into account.
}
\examples{

data(JobSat)
assocstats(JobSat)
GKgamma(JobSat)

}
\keyword{datasets}
