\name{varoc3d}
\alias{varoc3d}
\title{VAROC: value added receiver operating characteristics (ROC) curve}
\description{Three-dimensional VAROC curve.}
\usage{
varoc3d(y,x,zlim=NULL,plot=TRUE,digits=2,pval="no",B=2000)
}
\arguments{
  \item{y}{binary outcome, where y=1 if disease (or case) and y=0 if non-disease (or control).}
  \item{x}{continuous score, e.g. biomarker, diagnostic test, risk score.}
  \item{zlim}{minimum and maximum values of TMD, useful when comparing more than two scores (see Examples below).}
  \item{plot}{TRUE if three-dimensional VAROC curve is displayed.}
  \item{digits}{number of decimals.}
  \item{pval}{Bootstrap one-sided p-value if pval="yes".}
  \item{B}{Number of bootstrap samples.}
}

\details{Three-dimensional version of the VAROC curve. See the varoc function in details.}

\value{
\item{res1}{Metrics at each th (threshold): tpf, fpf, tmd=tpm-fpm, pvalue (alternative hypothesis: tpm>fpm (or tpm>0))}
\item{res2}{Global metrics: auc, iptm, ifpm, itmd=itpm-ifpm, pvalue (alternative hypothesis: itpm>ifpm (or itmd>0))}
}

\references{Danielle Brister and Yunro Chung, Value added receiver operating characteristics curve, Journal of Data Science (under review)}
\author{Yunro Chung [aut, cre]}

\examples{
set.seed(10)

n1=n0=25
y=c(rep(1,n1),rep(0,n0))

#1. useless marker
x1=abs(c(rnorm(n1,0,1),rnorm(n0,0,1)))
fit1=varoc3d(y=y,x=x1,plot=FALSE)

#2. useful marker
x2=abs(c(rnorm(n1,2,1),rnorm(n0,0,1)))
fit2=varoc3d(y=y,x=x2,plot=FALSE)

#3. markers 1 vs 2
opar=par(mfrow=c(1,2))
zlim=range(c(fit1$res1$tmd,fit2$res1$tmd))
fit1=varoc3d(y=y,x=x1,zlim=zlim)
fit2=varoc3d(y=y,x=x2,zlim=zlim)
on.exit(par(opar))
}
