% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_comparison.R
\name{export_results_csv}
\alias{export_results_csv}
\title{Export Results to CSV}
\usage{
export_results_csv(
  comparison_table = NULL,
  cv_results = NULL,
  sector_summary = NULL,
  output_dir = tempdir(),
  prefix = "valueprhr"
)
}
\arguments{
\item{comparison_table}{Data frame from compare_models.}

\item{cv_results}{Data frame from rolling_window_cv.}

\item{sector_summary}{Data frame from fit_bayesian_glm_sectors.}

\item{output_dir}{Directory for output files. Default tempdir().}

\item{prefix}{Filename prefix. Default "valueprhr".}
}
\value{
Character vector of created file paths.
}
\description{
Exports analysis results to CSV files.
}
\examples{
comparison <- data.frame(
  model = c("Model A", "Model B"),
  R2 = c(0.95, 0.92)
)
files <- export_results_csv(comparison_table = comparison)
print(files)

}
