% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.unvs.med.R
\name{summary.unvs.med}
\alias{summary.unvs.med}
\title{Summary of Formal Estimation for Causal Mediation Effects}
\usage{
\method{summary}{unvs.med} (object, form = "short", scale = "RD", ...)
}
\arguments{
\item{object}{a resulting object of class \code{'unvs.med'}
from function \code{\link{FormalEstmed}}.}

\item{form}{a character variable indicating the output form.
It can be \code{"short"} or \code{"long"}. The default is \code{"short"}.}

\item{scale}{a character variable of the effect scales. It can be \code{"RD"}, \code{"OR"} or \code{"RR"}.
If \code{scale} equals to string \code{"all"}, \code{"ALL"} or \code{"All"}, then effects on three scales will be displayed.
The default is \code{"RD"}.}

\item{...}{additional parameters passed to "summary".

In addition, The function identifies it as the same string if the first letter is capital or all letters are capital.
For example, \code{"short"} equals to \code{"Short"} and \code{"SHORT"}.}
}
\value{
No return value, called for displaying the output of the estimation result.
}
\description{
This function presents the refined statistics results of the mediation effects on risk difference (RD),
odds ratio (OR) and risk difference (RR) scales
from function \code{\link{FormalEstmed}}.
This function is applied on the resulting object of class \code{"unvs.med"} from function \code{\link{FormalEstmed}}.
The output shows the mean, standard error, t-statistics, p-value and confident interval of the effect estimates based on
bootstrapping estimations.
}
\examples{
\donttest{
# Running formal estimation
data(testdata)
med_model=glm(med~exp+C1+C2+C3, data=testdata, family=binomial) # Fitting mediator's model
out_model=lm(out~med*exp+C1+C2+C3, data=testdata) # Fitting outcome's model
r1 = FormalEstmed (med_model=med_model, out_model=out_model,
data=testdata, exposure = "exp") # Running formal estimation via bootstrapping

# Summary examples
summary(r1) # Summary of the default settings (Short form and on RD scales).
summary(r1, "long") # Summary of long form and on RD scales.
summary(r1, "long", "OR") # Summary of long form and on OR scales.
summary(r1, "long", "RR") # Summary of long form and on RR scales.
summary(r1, "long", "all") # Summary of long form and on all scales.
summary(r1, form="short", scale="all") # Summary of short form and on all scales.
}

}
