% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_wide4lmer}
\alias{umx_wide4lmer}
\title{Take a long dataframe and make it wide for repeated measures and multi-level analysis}
\usage{
umx_wide4lmer(
  repeated = list(y = c("y1", "y2")),
  timevar = list(cond = c("cont", "expt")),
  covs = c("Age", "Sex", "Conscientiousness"),
  data = df,
  idvar = "PID"
)
}
\arguments{
\item{repeated}{list of repeated measures each in list(y = c("y1", "y2")) form}

\item{timevar}{list of conditions in a list, e.g., list(condition = c("cont", "expt")),}

\item{covs}{vector of covariates e.g., c("Age", "Sex", "Conscientiousness")}

\item{data}{A (long-format) data file}

\item{idvar}{The variable which links repeated measures, e.g., "ID"}
}
\description{
\code{umx_wide4lmer} Transform data from wide to long format for repeated measures and multi-level modeling in R.

Wraps reshape \code{\link[stats:reshape]{stats::reshape()}}
}
\examples{
\dontrun{
covs = c("Age", "Sex", "Conscientiousness")
timevar  = list(Difficulty = c("short", "long"))
repeated = list(
	Frustration = c("NASA_Frustration1", "NASA_Frustration2"),
	Effort      = c("NASA_Effort1"     , "NASA_Effort2"),
	Efficacy    = c("NASA_Performance1", "NASA_Performance2"), 
	Howmany     = c("howmany_30secs"   , "howmany_60secs")
)
df.l = umx_wide4lmer(repeated = repeated, timevar = timevar, covs = covs, data = df, idvar = "PID")
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umx_long2wide]{umx_long2wide()}}
}

Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{libs}()},
\code{\link{qm}()},
\code{\link{umx}},
\code{\link{umxLav2RAM}()},
\code{\link{umxModelNames}()},
\code{\link{umxRAM2Lav}()},
\code{\link{umxVersion}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_lower.tri}()},
\code{\link{umx_msg}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_pad}()},
\code{\link{umx_print}()},
\code{\link{umx_wide2long}()}
}
\concept{Miscellaneous Utility Functions}
