% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{m4}
\alias{m4}
\title{M4 Competition Time Series}
\format{
A list of lists containing time series.
}
\source{
\href{https://github.com/Mcompetitions/M4-methods}{M4 Competition - GitHub}
}
\usage{
data(m4)
}
\description{
Time series data from the fourth Makridakis forecasting competition (M4), held in 2018.
Data Type: Forecasting benchmark dataset. Category: Forecasting. Creation Date: 2018.
}
\details{
Consolidated list keyed by frequency (e.g., \code{daily}, \code{hourly}, \code{monthly}, ...). Each holds a list of numeric vectors.
See Makridakis et al. (2020) for an overview of M4 findings.
}
\examples{
# Load consolidated M4 list and plot one available series
data(m4)
# m4 <- loadfulldata(m4)
freq_name <- names(m4)[1]
series_name <- names(m4[[freq_name]])[1]
series <- m4[[freq_name]][[series_name]]
ts.plot(series, main = paste("M4", freq_name, "series:", series_name))
}
\references{
Makridakis et al. (2020). The M4 Competition: Results, findings, conclusion and way forward. International Journal of Forecasting, 36(1), 54–74.
}
\keyword{datasets}
