% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{CATS}
\alias{CATS}
\title{CATS Time Series Competition}
\format{
A data frame with five columns and 980 rows. Each column represents a known segment of the time series.
}
\source{
\href{https://archive.ics.uci.edu/dataset/204/cats}{CATS Time Series Competition}
}
\usage{
data(CATS)
}
\description{
Univariate time series from the CATS (Competition on Artificial Time Series) benchmark.
Data Type: Artificial time series with missing blocks. Category: Benchmark. Observations: 5,000 (4,900 known, 100 missing).
The dataset contains five non-consecutive blocks of 20 missing values each. Competitors were asked to predict these 100 unknown points, and performance was evaluated using MSE (E1 for all unknowns and E2 for the first 80 points).
}
\details{
The CATS benchmark contains artificial series with five nonconsecutive missing blocks of 20 points each.
Models must impute or forecast the missing blocks; evaluation typically uses MSE over all missing points.
}
\examples{
# Load CATS dataset
data(CATS)
# CATS <- loadfulldata(CATS)
}
\references{
Lendasse, A., Oja, E., Simula, O., Verleysen, M., et al. (2004). \emph{Time Series Prediction Competition: The CATS Benchmark}. In IJCNN'2004 - International Joint Conference on Neural Networks.
Lendasse, A., Oja, E., Simula, O., Verleysen, M. (2007). \emph{Time Series Prediction Competition: The CATS Benchmark}. Neurocomputing, 70(13-15), 2325–2329.
}
\keyword{benchmark}
\keyword{datasets}
