################################################################################
# Performs paired z test for equivalence binary data
# Author: Alexis Dinno <alexis.dinno@pdx.edu>
# version 3.1.9 
# Date: Jan 28, 2026

equivalence.types <- c("delta", "epsilon")

continuity.correction.methods <- c("none", "yates", "edwards")

tost.mcc <- function(
    x=NA,
    y=NA,
    frequency=NA,
    eqv.type=equivalence.types,
    eqv.level=1,
    upper=NA,
    ccontinuity=continuity.correction.methods,
    conf.level=0.95,
    relevance=TRUE) {
  # Validate that x and y are binary vectors of same length
  x <- x[complete.cases(x)]
  y <- y[complete.cases(y)]
  if (!all(x %in% 0:1)) {
    stop("x must contain only binary (0/1) data")
    }
  if (!all(y %in% 0:1)) {
    stop("y must contain only binary (0/1) data")
    }
  if (length(x) != length(y)) {
    stop("x and y must be the same length")
    }
  # Validate frequency weights
  if (length(frequency)!=length(x) & length(frequency)!=1) {
    stop("frequency must be the same length as x and y")
    }
  if (length(frequency)==1 & !all(is.na(frequency))) {
    stop("frequency must the same length as x and y, and contain an integer indicating the\n  number of duplicated observations")
    }
  if (length(frequency)>1 & (!all(frequency%%1 == 0) | !all(frequency>=0))) {
    stop("frequency must contain only non-negative integers")
    }

  # Create a, b, c, and d
  # If frequency weights are not provided
  if (all(is.na(frequency))) {
    a <- length(x[x==1 & y==1])
    b <- length(x[x==1 & y==0])
    c <- length(x[x==0 & y==1])
    d <- length(x[x==0 & y==0])
    }
  # If frequency weights are provided
   else {
    a <- sum(frequency[x==1 & y==1])
    b <- sum(frequency[x==1 & y==0])
    c <- sum(frequency[x==0 & y==1])
    d <- sum(frequency[x==0 & y==0])
    }

  # Call tost.mcci to conduct that actual test
  tost.mcci(
    a=a, 
    b=b, 
    c=c, 
    d=d, 
    eqv.type=eqv.type, 
    eqv.level=eqv.level, 
    upper=upper, 
    ccontinuity=ccontinuity, 
    conf.level=conf.level, 
    relevance=relevance)
  }
